//********************************************************************/
//*                                                                 */
//*                      ADOBE CONFIDENTIAL                         */
//*                   _ _ _ _ _ _ _ _ _ _ _ _ _                     */
//*                                                                 */
//* Copyright 1986 - 2000 Adobe Systems Incorporated                */
//* All Rights Reserved.                                            */
//*                                                                 */
//* NOTICE:  All information contained herein is, and remains the   */
//* property of Adobe Systems Incorporated and its suppliers, if    */
//* any.  The intellectual and technical concepts contained         */
//* herein are proprietary to Adobe Systems Incorporated and its    */
//* suppliers and may be covered by U.S. and Foreign Patents,       */
//* patents in process, and are protected by trade secret or        */
//* copyright law.  Dissemination of this information or            */
//* reproduction of this material is strictly forbidden unless      */
//* prior written permission is obtained from Adobe Systems         */
//* Incorporated.                                                   */
//*                                                                 */
//*******************************************************************/
/*
 * Name:
 *	PIHandleSuite.h
 *
 * Copyright 1986-2000 Adobe Systems Incorporated.
 * All Rights Reserved.
 *
 * Purpose:
 *	Photoshop Handle Suite for Plug-ins.
 *
 * Distribution:
 *	PUBLIC
 *
 * Version history:
 *	1.0.0 4/1/1998	JF	First Version.
 *		Created by Josh Freeman.
 */

#ifndef __PIHandleSuite__
#define __PIHandleSuite__

#include "PIGeneral.h"

#ifdef __cplusplus
extern "C" {
#endif

/******************************************************************************/

#define kPSHandleSuite 			"Photoshop Handle Suite for Plug-ins"

//-------------------------------------------------------------------------------
//	Handle suite typedefs
//-------------------------------------------------------------------------------

typedef MACPASCAL void (*SetPIHandleLockProc) (Handle h, Boolean lock, Ptr *address, Boolean *oldLock);

//-------------------------------------------------------------------------------
//	Handle suite version 1
//-------------------------------------------------------------------------------

#define kPSHandleSuiteVersion1		1
#define kPSHandleSuiteVersion2		2

typedef struct
{
	NewPIHandleProc New;
	DisposePIHandleProc Dispose;
	SetPIHandleLockProc SetLock;
	GetPIHandleSizeProc GetSize;
	SetPIHandleSizeProc SetSize;
	RecoverSpaceProc RecoverSpace;
	
} PSHandleSuite1;

typedef struct
{
	NewPIHandleProc New;
	DisposePIHandleProc Dispose;
	DisposeRegularHandlePIHandleProc DisposeRegularHandle;
	SetPIHandleLockProc SetLock;
	GetPIHandleSizeProc GetSize;
	SetPIHandleSizeProc SetSize;
	RecoverSpaceProc RecoverSpace;
	
} PSHandleSuite2;

/******************************************************************************/

#ifdef __cplusplus
}
#endif


#endif	// PIHandleSuite
